/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_19; import java.util.Vector;

import djbuch.kapitel_13.DJDocument;
import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class NLDocument extends DJDocument {
	
	private static final String FIELD_ACTIVE = "F_isactive";
	private static final String FIELD_BODY = "F_body";
	private static final String FIELD_SUBJECT = "F_subject";
	private static final String FIELD_RECIPIENTS = "F_recipients";
	private static final String FIELD_FORM = "Form";
	protected static final String DEFAULT_FORM = "FO_NLDoc_k19";
	
	/**
	 * erzeugt ein neues NL Document anhand eines Domino
	 * Document.
	 * @param initialDoc
	 * @return - null, falls initialDoc==null, sonst ein neues NLDocument
	 */
	public static NLDocument getInstance (Document initialDoc) {
		if (initialDoc==null) {
			return null;
		} else {
			return new NLDocument (initialDoc);
		}
	}
	
	/** 
	 * erzeugt ein neues NLDocument, erstellt dieses jedoch als
	 * neues Domino Document in der Datenbank db
	 * @param db
	 * @return - neues NLDocument, falls db != null, sonst null
	 * @throws NotesException
	 */
	public static NLDocument getInstance (Database db) throws NotesException {
		if (db==null) {
			return null;
		} else {
			Document doc = db.createDocument();
			doc.replaceItemValue (FIELD_FORM, DEFAULT_FORM);
			doc.save (true,false);
			return getInstance (doc);
		}
	}
	
	/** Empfnger dieses Newsletters */
	public Vector getRecipients () throws NotesException {
		Vector v = this.getItemValue(FIELD_RECIPIENTS);
		return (v==null?new Vector():v);
	}
	
	/** Empfnger dieses Newsletters festlegen */
	public Item setRecipients (Vector recip) throws NotesException {
		return this.replaceItemValue(FIELD_RECIPIENTS, recip);
	}

	/** Inhalt dieses Newsletters */
	public String getBody () throws NotesException {
		RichTextItem rt = (RichTextItem) this.getFirstItem(FIELD_BODY);
		return rt == null?null:rt.getFormattedText(false,0,0);
	}
	
	/**
	 * weisst dem Body RichTextITem einen neuen Wert zu.
	 * Achtung Nebenwirkung: Um das RTItem erfolgreich setzen zu knnen,
	 * wird das Document gespeichert.
	 * @param bodyText
	 * @return - RichTextItem
	 * @throws NotesException
	 */	
	public RichTextItem setBody (String bodyText) throws NotesException {
		RichTextItem rt = null;
		if (hasItem (FIELD_BODY)) {
			removeItem(FIELD_BODY);
			save (true,false);
		}
		rt = createRichTextItem(FIELD_BODY);
		rt.appendText(bodyText);
		save (true,false);
		return rt;
	}
	
	public boolean isActive () throws NotesException {
		if (this.hasItem(FIELD_ACTIVE)) {
			return this.getItemValueInteger(FIELD_ACTIVE) == 1;
		} else {
			return false;
		}
	}
	
	/** Aktiviert oder De-Aktiviert den Newsletter */
	public void setActive (boolean flag) throws NotesException {
		this.replaceItemValue (FIELD_ACTIVE,new Integer (flag?1:0));
	}
	
	public String getSubject () throws NotesException {
		return this.getItemValueString(FIELD_SUBJECT);
	}
	public Item setSubject (String subj) throws NotesException {
		return this.replaceItemValue(FIELD_SUBJECT, subj);
	}
	
	/* Das NLDocument soll nur ber getInstance bezogen werden,
	 * um ein null-Document zu erhalten, falls das zugrunde
	 * liegende Document ebenfalls null ist.
	 */
	private NLDocument (Document doc) {
		//this is private -> please use getInstance
		super (doc);
	}
}